<?php
require_once 'config.php';
requireLogin();

$transactions = [];

try {
    $conn = getDBConnection();

    // Fetch all deposit transactions for the logged-in user
    $stmt = $conn->prepare("SELECT id, user_id, amount, type, method, description, reference_number, status, created_at FROM transactions WHERE user_id = ? AND type = 'deposit' ORDER BY created_at DESC");
    if ($stmt === false) {
        throw new Exception('Prepare transactions statement failed: ' . $conn->error);
    }
    $stmt->bind_param('i', $_SESSION['user_id']);
    $stmt->execute();
    $result = $stmt->get_result();
    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $transactions[] = $row;
        }
    }
    $stmt->close();

} catch (Exception $e) {
    $error = 'حدث خطأ أثناء تحميل البيانات: ' . $e->getMessage();
}

require_once 'header.php';
?>

<div class="container mt-5">
    <div class="card">
        <div class="card-header">
            <h5 class="mb-0">سجل المعاملات</h5>
        </div>
        <div class="card-body">
            <?php if (isset($error)): ?>
                <div class="alert alert-danger" role="alert">
                    <?= htmlspecialchars($error) ?>
                </div>
            <?php endif; ?>

            <div class="table-responsive">
                <table class="table table-hover table-striped">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>معرف المستخدم</th>
                            <th>المبلغ</th>
                            <th>الوسيلة</th>
                            <th>الوصف</th>
                            <th>رقم المرجع</th>
                            <th>الحالة</th>
                            <th>تاريخ الإنشاء</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (!empty($transactions)): ?>
                            <?php foreach ($transactions as $transaction): ?>
                            <tr>
                                <td><?= htmlspecialchars($transaction['id'] ?? 'N/A') ?></td>
                                <td><?= htmlspecialchars($transaction['user_id'] ?? 'N/A') ?></td>
                                <td><?= htmlspecialchars($transaction['amount'] ?? 'N/A') ?> $</td>
                                <td><?= htmlspecialchars($transaction['method'] ?? 'N/A') ?></td>
                                <td><?= htmlspecialchars($transaction['description'] ?? 'N/A') ?></td>
                                <td><?= htmlspecialchars($transaction['reference_number'] ?? 'N/A') ?></td>
                                <td>
                                    <span class="badge bg-<?= ($transaction['status'] ?? '') === 'completed' ? 'success' : (($transaction['status'] ?? '') === 'pending' ? 'warning' : 'danger') ?>">
                                        <?= htmlspecialchars($transaction['status'] ?? 'N/A') ?>
                                    </span>
                                </td>
                                <td><?= htmlspecialchars($transaction['created_at'] ?? 'N/A') ?></td>
                            </tr>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="8" class="text-center">لا توجد إيداعات لعرضها.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php require_once 'footer.php'; ?>
